# DEVONthink AppleScript API Reference

## Commands

### Standard Suite Commands

#### `close`
- **Description**: Close a window, tab or database
- **Direct Parameter**: specifier - The window(s), tab(s) or database(s) to close
- **Parameters**:
  - `saving` (save options, optional): Should changes be saved before closing?
- **Returns**: N/A

#### `save`
- **Description**: Save a window or tab
- **Direct Parameter**: specifier - The window(s) or tab(s) to save
- **Returns**: N/A

#### `print`
- **Description**: Print a window or tab
- **Direct Parameter**: specifier - The window(s) or tab(s) to be printed
- **Parameters**:
  - `with properties` (print settings, optional): The print settings to use
  - `print dialog` (boolean, optional): Should the application show the print dialog?
- **Returns**: N/A

#### `quit`
- **Description**: Quit the application
- **Parameters**:
  - `saving` (save options, optional): Should changes be saved before quitting?
- **Returns**: N/A

#### `count`
- **Description**: Return the number of elements of a particular class within an object
- **Direct Parameter**: specifier - The objects to be counted
- **Parameters**:
  - `each` (type, optional): The class of objects to be counted
- **Returns**: integer

#### `exists`
- **Description**: Verify that an object exists
- **Direct Parameter**: any - The object(s) to check
- **Returns**: boolean

#### `make`
- **Description**: Create a new object
- **Parameters**:
  - `new` (type): The class of the new object
  - `at` (location specifier, optional): The location at which to insert the object
  - `with data` (any, optional): The initial contents of the object
  - `with properties` (dictionary, optional): The initial values for properties of the object
- **Returns**: specifier - The new object

### DEVONthink Suite Commands

#### `add custom meta data`
- **Description**: Add user-defined metadata to a record or updates already existing metadata
- **Direct Parameter**: rich text | text | number | integer | real | boolean | date - The value to add
- **Parameters**:
  - `for` (text): The key for the user-defined value
  - `to` (record): The record
  - `as` (text, optional): The desired format. Either "text" (default), "richtext", "string", "uuid", "url", "crosslink", "date", "real", "int", "bool", "set", "countries", or "languages"
- **Returns**: boolean

#### `add download`
- **Description**: Add a URL to the download manager
- **Direct Parameter**: text - The URL to add
- **Parameters**:
  - `automatic` (boolean, optional): Automatic or user download
  - `password` (text, optional): The password for protected websites
  - `referrer` (text, optional): The HTTP referrer
  - `user` (text, optional): The user name for protected websites
- **Returns**: boolean

#### `add reading list`
- **Description**: Add record or URL to reading list
- **Parameters**:
  - `record` (record, optional): The record
  - `URL` (text, optional): The URL of the webpage
  - `title` (text, optional): The title of the webpage
- **Returns**: boolean

#### `add reminder`
- **Description**: Add a new reminder to a record
- **Direct Parameter**: dictionary - The properties of the reminder
- **Parameters**:
  - `to` (record): The record
- **Returns**: reminder | missing value

#### `add row`
- **Description**: Add new row to a sheet
- **Direct Parameter**: specifier - The tab, window or record of a sheet.
- **Parameters**:
  - `cells` (text list): Cells of new row
- **Returns**: boolean

#### `check file integrity of`
- **Description**: Check file integrity of database
- **Parameters**:
  - `database` (database): The database to check
- **Returns**: integer - Number of files having an invalid content hash

#### `classify`
- **Description**: Get a list of classification proposals
- **Parameters**:
  - `record` (record): The record to classify
  - `in` (database, optional): The database
  - `comparison` (comparison type, optional): The comparison to use
  - `tags` (boolean, optional): Propose ordinary tags instead of groups
- **Returns**: parent list | missing value

#### `compare`
- **Description**: Get a list of similar records
- **Parameters**:
  - `record` (content, optional): The record to compare
  - `content` (text, optional): The content to compare
  - `to` (database, optional): The database
  - `comparison` (comparison type, optional): The comparison to use
- **Returns**: content list | missing value

#### `compress`
- **Description**: Compress a database into a Zip archive
- **Parameters**:
  - `database` (database): The database to compress
  - `password` (text, optional): The required password
  - `to` (text): POSIX path or file URL of Zip archive
- **Returns**: boolean

#### `convert`
- **Description**: Convert a record to plain or rich text, formatted note or HTML and create a new record afterwards
- **Parameters**:
  - `record` (content | content list): The record(s) to convert
  - `to` (convert type, optional): The desired format
  - `in` (parent, optional): The destination group
- **Returns**: content | content list | missing value

#### `convert feed to HTML`
- **Description**: Convert a RSS, RDF, JSON or Atom feed to HTML
- **Direct Parameter**: text - The source code of the feed
- **Parameters**:
  - `base URL` (text, optional): The URL of the feed
- **Returns**: text | missing value

#### `create database`
- **Description**: Create a new database
- **Direct Parameter**: text - POSIX file path of database
- **Parameters**:
  - `encryption key` (text, optional): The encryption key
  - `size` (integer, optional): The maximal size in MB
- **Returns**: database | missing value

#### `create formatted note from`
- **Description**: Create a new formatted note from a web page
- **Direct Parameter**: text - The URL to download
- **Parameters**:
  - `agent` (text, optional): The user agent
  - `in` (parent, optional): The destination group
  - `name` (text, optional): The name for the new record
  - `readability` (boolean, optional): Declutter page layout
  - `referrer` (text, optional): The HTTP referrer
  - `source` (text, optional): The HTML source
- **Returns**: content | missing value

#### `create location`
- **Description**: Create a hierarchy of groups if necessary
- **Direct Parameter**: text - The hierarchy as a POSIX path
- **Parameters**:
  - `in` (database | parent, optional): The destination database or group
- **Returns**: parent | missing value

#### `create Markdown from`
- **Description**: Create a Markdown document from a web resource
- **Direct Parameter**: text - The URL to download
- **Parameters**:
  - `agent` (text, optional): The user agent
  - `in` (parent, optional): The destination group
  - `name` (text, optional): The name for the new record
  - `readability` (boolean, optional): Declutter page layout
  - `referrer` (text, optional): The HTTP referrer
- **Returns**: content | missing value

#### `create PDF document from`
- **Description**: Create a new PDF document with or without pagination from a web resource
- **Direct Parameter**: text - The URL to download
- **Parameters**:
  - `agent` (text, optional): The user agent
  - `in` (parent, optional): The destination group
  - `name` (text, optional): The name for the new record
  - `pagination` (boolean, optional): Paginate PDF document or not
  - `readability` (boolean, optional): Declutter page layout
  - `referrer` (text, optional): The HTTP referrer
  - `width` (number, optional): The preferred width in points
- **Returns**: content | missing value

#### `create record with`
- **Description**: Create a new record
- **Direct Parameter**: dictionary - The properties of the record
- **Parameters**:
  - `in` (parent, optional): The destination group
- **Returns**: record | missing value

#### `create thumbnail`
- **Description**: Create or update existing thumbnail of a record
- **Parameters**:
  - `for` (record): The record
- **Returns**: boolean

#### `create web document from`
- **Description**: Create a new record from a web resource
- **Direct Parameter**: text - The URL to download
- **Parameters**:
  - `agent` (text, optional): The user agent
  - `in` (parent, optional): The destination group
  - `name` (text, optional): The name for the new record
  - `readability` (boolean, optional): Declutter page layout
  - `referrer` (text, optional): The HTTP referrer
- **Returns**: content | missing value

#### `delete`
- **Description**: Delete all instances of a record from the database
- **Parameters**:
  - `record` (record | record list): The record(s) to delete
  - `in` (parent, optional): The parent group of this instance
- **Returns**: boolean

#### `delete row at`
- **Description**: Remove row at specified position from a sheet
- **Direct Parameter**: specifier - The tab, window or record of a sheet.
- **Parameters**:
  - `position` (integer): Position of row (1...n)
- **Returns**: boolean

#### `delete thumbnail`
- **Description**: Delete existing thumbnail of a record
- **Parameters**:
  - `of` (record): The record
- **Returns**: boolean

#### `delete workspace`
- **Description**: Delete a workspace
- **Direct Parameter**: text - The name of the workspace
- **Returns**: boolean

#### `do JavaScript`
- **Description**: Executes a string of JavaScript code
- **Direct Parameter**: text - The code
- **Parameters**:
  - `in` (think window, optional): The think window for execution
- **Returns**: text | missing value

#### `download image for prompt`
- **Description**: Download image for a prompt
- **Direct Parameter**: text - The prompt to send
- **Parameters**:
  - `prompt strength` (real, optional): Prompt strength (0.0-1.0)
  - `image` (raw data | text, optional): Optional image data or URL
  - `engine` (image engine, optional): The desired engine
  - `quality` (text, optional): The quality of the image
  - `aspect ratio` (text, optional): The aspect ratio of the image (1:1, 16:9, 9:16, 4:3, 3:4)
  - `style` (text, optional): The style of the image
  - `seed` (integer, optional): Set for reproducible generation
- **Returns**: raw data | missing value

#### `download JSON from`
- **Description**: Download a JSON object
- **Direct Parameter**: text - The URL of the JSON object
- **Parameters**:
  - `agent` (text, optional): The user agent
  - `method` (text, optional): The HTTP method
  - `password` (text, optional): The password
  - `post` (dictionary, optional): Key-value pairs for HTTP POST
  - `referrer` (text, optional): The HTTP referrer
  - `user` (text, optional): The user name
- **Returns**: dictionary | missing value

#### `download markup from`
- **Description**: Download an HTML or XML page
- **Direct Parameter**: text - The URL to download
- **Parameters**:
  - `agent` (text, optional): The user agent
  - `encoding` (text, optional): The encoding of the page
  - `method` (text, optional): The HTTP method
  - `password` (text, optional): The password
  - `post` (dictionary, optional): Key-value pairs for HTTP POST
  - `referrer` (text, optional): The HTTP referrer
  - `user` (text, optional): The user name
- **Returns**: text | missing value

#### `download URL`
- **Description**: Download a URL
- **Direct Parameter**: text - The URL to download
- **Parameters**:
  - `agent` (text, optional): The user agent
  - `method` (text, optional): The HTTP method
  - `password` (text, optional): The password
  - `post` (dictionary, optional): Key-value pairs for HTTP POST
  - `referrer` (text, optional): The HTTP referrer
  - `user` (text, optional): The user name
- **Returns**: raw data | missing value

#### `display authentication dialog`
- **Description**: Display a dialog to enter a username and its password
- **Direct Parameter**: text (optional) - The info for the dialog
- **Returns**: authentication result | missing value

#### `display chat dialog`
- **Description**: Display a dialog to show the response for a chat prompt
- **Direct Parameter**: specifier - The tab or window
- **Parameters**:
  - `name` (text, optional): The title of the dialog
  - `role` (text, optional): The desired role for the chat
  - `prompt` (text): The desired prompt
  - `model` (text, optional): The desired model
  - `engine` (chat engine, optional): The desired engine
  - `temperature` (real, optional): The desired temperature
- **Returns**: text | missing value

#### `display date editor`
- **Description**: Display a dialog to enter a date
- **Direct Parameter**: text (optional) - The title of the dialog
- **Parameters**:
  - `default date` (date, optional): The default date
  - `info` (text, optional): The info for the dialog
- **Returns**: date | missing value

#### `display group selector`
- **Description**: Display a dialog to select a destination group
- **Direct Parameter**: text (optional) - The title of the dialog
- **Parameters**:
  - `buttons` (text list, optional): The labels for buttons
  - `for` (database, optional): The database
  - `name` (boolean, optional): Show field to enter a name
  - `tags` (boolean, optional): Show field to enter tags
- **Returns**: parent | group selector result | missing value

#### `display name editor`
- **Description**: Display a dialog to enter a name
- **Direct Parameter**: text (optional) - The title of the dialog
- **Parameters**:
  - `default answer` (text, optional): The default editable name
  - `info` (text, optional): The info for the dialog
- **Returns**: text | missing value

#### `duplicate`
- **Description**: Duplicate a record
- **Parameters**:
  - `record` (record | record list): The record(s) to duplicate
  - `to` (parent): The destination group
- **Returns**: record | record list | missing value

#### `exists record at`
- **Description**: Check if at least one record exists at the specified location
- **Direct Parameter**: text - The location as a POSIX path
- **Parameters**:
  - `in` (database | parent, optional): The base database or group
- **Returns**: boolean

#### `exists record with comment`
- **Description**: Check if at least one record with the specified comment exists
- **Direct Parameter**: text - The comment
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: boolean

#### `exists record with content hash`
- **Description**: Check if at least one record with the specified content hash exists
- **Direct Parameter**: text - The content hash
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: boolean

#### `exists record with file`
- **Description**: Check if at least one record with the specified filename exists
- **Direct Parameter**: text - The filename
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: boolean

#### `exists record with path`
- **Description**: Check if at least one record with the specified path exists
- **Direct Parameter**: text - The path
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: boolean

#### `exists record with URL`
- **Description**: Check if at least one record with the specified URL exists
- **Direct Parameter**: text - The URL or path
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: boolean

#### `export`
- **Description**: Export a record and its children
- **Parameters**:
  - `record` (record): The record to export
  - `to` (text): The destination directory as a POSIX path
  - `DEVONtech_Storage` (boolean, optional): Export metadata files
- **Returns**: text | missing value

#### `export tags of`
- **Description**: Export Finder tags of a record
- **Parameters**:
  - `record` (record): The record
- **Returns**: boolean

#### `export website`
- **Description**: Export a record and its children as a website
- **Parameters**:
  - `record` (record): The record to export
  - `to` (text): The destination directory
  - `template` (text, optional): Name of template or POSIX path
  - `index pages` (boolean, optional): Create index pages
  - `encoding` (text, optional): The encoding of exported HTML
  - `entities` (boolean, optional): Use HTML entities
- **Returns**: text | missing value

#### `extract keywords from`
- **Description**: Extract list of keywords from a record
- **Parameters**:
  - `record` (record): The record
  - `barcodes` (boolean, optional): Include scanned barcodes
  - `existing tags` (boolean, optional): Include existing tags
  - `hash tags` (boolean, optional): Include hash tags
  - `image tags` (boolean, optional): Include suggested image tags
- **Returns**: text list | missing value

#### `get cached data for URL`
- **Description**: Get cached data for URL of a resource
- **Direct Parameter**: text - The URL
- **Parameters**:
  - `from` (tab, optional): The source think tab
- **Returns**: raw data | missing value

#### `get cell at`
- **Description**: Get content of cell at specified position of a sheet
- **Direct Parameter**: specifier - The tab, window or record of a sheet.
- **Parameters**:
  - `column` (integer | text): The index or name of the column
  - `row` (integer): The row of the cell
- **Returns**: text | missing value

#### `get chat capabilities for engine`
- **Description**: Retrieve capabilities of a model for a certain engine
- **Direct Parameter**: chat engine - The engine
- **Parameters**:
  - `model` (text): The model
- **Returns**: chat model capabilities | missing value

#### `get chat models for engine`
- **Description**: Retrieve list of supported models of a chat engine
- **Direct Parameter**: chat engine - The engine
- **Returns**: text list

#### `get chat response for message`
- **Description**: Retrieve the response for a chat message
- **Direct Parameter**: text | dictionary | dictionary list - The prompt or message(s)
- **Parameters**:
  - `record` (record | record list, optional): Optional documents or bookmarks
  - `mode` (text, optional): The record's contents to use
  - `image` (raw data, optional): Optional image data
  - `URL` (text, optional): Optional path or URL
  - `model` (text, optional): The desired model
  - `role` (text, optional): The desired role
  - `engine` (chat engine, optional): The desired engine
  - `temperature` (real, optional): The desired temperature
  - `thinking` (boolean, optional): Allow optional thinking
  - `tool calls` (boolean, optional): Allow usage of tool calls
  - `usage` (chat usage, optional): The desired usage mode
  - `as` (text, optional): The response format. Either "text" (default), "JSON", "HTML", "PDF", "message", or "raw"
- **Returns**: text | array | dictionary | raw data | missing value

#### `get concordance of`
- **Description**: Get list of words of a record
- **Parameters**:
  - `record` (content): The record
  - `sorted by` (concordance sorting, optional): Sorting of words
- **Returns**: text list | missing value

#### `get custom meta data`
- **Description**: Get user-defined metadata from a record
- **Parameters**:
  - `default value` (rich text | text | number | integer | real | boolean | date, optional): Default value
  - `for` (text): The key of the user-defined value
  - `from` (record): The record
- **Returns**: date | rich text | text | number | integer | real | boolean | missing value

#### `get database with id`
- **Description**: Get database with the specified id
- **Direct Parameter**: integer - The scripting identifier
- **Returns**: database | missing value

#### `get database with uuid`
- **Description**: Get database with the specified uuid
- **Direct Parameter**: text - The unique identifier
- **Returns**: database | missing value

#### `get embedded images of`
- **Description**: Get the URLs of all embedded images of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Parameters**:
  - `base URL` (text, optional): The URL of the HTML page
  - `file type` (text, optional): The desired type of images
- **Returns**: text list | missing value

#### `get embedded objects of`
- **Description**: Get the URLs of all embedded objects of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Parameters**:
  - `base URL` (text, optional): The URL of the HTML page
  - `file type` (text, optional): The desired type of objects
- **Returns**: text list | missing value

#### `get embedded sheets and scripts of`
- **Description**: Get the URLs of all embedded style sheets and scripts of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Parameters**:
  - `base URL` (text, optional): The URL of the HTML page
  - `file type` (text, optional): The desired type of sheets/scripts
- **Returns**: text list | missing value

#### `get favicon of`
- **Description**: Get the favicon of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Parameters**:
  - `base URL` (text, optional): The URL of the HTML page
- **Returns**: text | missing value

#### `get feed items of`
- **Description**: Get the feed items of a RSS, RDF, JSON or Atom feed
- **Direct Parameter**: text - The source code of the feed
- **Parameters**:
  - `base URL` (text, optional): The URL of the feed
- **Returns**: feed item list | missing value

#### `get frames of`
- **Description**: Get the URLs of all frames of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Parameters**:
  - `base URL` (text, optional): The URL of the HTML page
- **Returns**: text list | missing value

#### `get items of feed`
- **Description**: Get the items of a RSS, RDF, JSON or Atom feed as dictionaries
- **Direct Parameter**: text - The source code of the feed
- **Parameters**:
  - `base URL` (text, optional): The URL of the feed
- **Returns**: dictionary list | missing value

#### `get links of`
- **Description**: Get the URLs of all links of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Parameters**:
  - `base URL` (text, optional): The URL of the HTML page
  - `containing` (text, optional): String matched against link descriptions
  - `file type` (text, optional): The desired type of links
- **Returns**: text list | missing value

#### `get metadata of`
- **Description**: Get the metadata of an HTML page or Markdown document
- **Direct Parameter**: text (optional) - The source code of the HTML page
- **Parameters**:
  - `base URL` (text, optional): The URL of the HTML page
  - `markdown` (text, optional): The source of the Markdown document
- **Returns**: dictionary | missing value

#### `get record at`
- **Description**: Search for record at the specified location
- **Direct Parameter**: text - The location as a POSIX path
- **Parameters**:
  - `in` (database | parent, optional): The base database or group
- **Returns**: record | missing value

#### `get record with id`
- **Description**: Get record with the specified id
- **Direct Parameter**: integer - The scripting identifier
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: record | missing value

#### `get record with uuid`
- **Description**: Get record with the specified uuid or item link
- **Direct Parameter**: text - The unique identifier or item link
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: record | missing value

#### `get rich text of`
- **Description**: Get the rich text of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Parameters**:
  - `base URL` (text, optional): The URL of the HTML page
- **Returns**: rich text | missing value

#### `get text of`
- **Description**: Get the text of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Returns**: text | missing value

#### `get title of`
- **Description**: Get the title of an HTML page
- **Direct Parameter**: text - The source code of the HTML page
- **Returns**: text | missing value

#### `get versions of`
- **Description**: Get saved versions of a record
- **Parameters**:
  - `record` (record): The record
- **Returns**: record list | missing value

#### `hide progress indicator`
- **Description**: Hide a visible progress indicator
- **Returns**: boolean

#### `import attachments of`
- **Description**: Import attachments of an email
- **Parameters**:
  - `record` (record): The record of an email
  - `to` (parent, optional): The destination group
- **Returns**: record list | missing value

#### `import path`
- **Description**: Import a file or folder
- **Direct Parameter**: text - The POSIX path or file URL
- **Parameters**:
  - `from` (text, optional): The name of the source application
  - `name` (text, optional): The name for the imported record
  - `placeholders` (dictionary, optional): Optional placeholders
  - `to` (parent, optional): The destination group
- **Returns**: record | missing value

#### `import template`
- **Description**: Import a template
- **Direct Parameter**: text - The POSIX path or file URL of the template
- **Parameters**:
  - `to` (parent, optional): The destination group
- **Returns**: record | missing value

#### `index path`
- **Description**: Index a file or folder
- **Direct Parameter**: text - The POSIX path or file URL
- **Parameters**:
  - `to` (parent, optional): The destination group
- **Returns**: record | missing value

#### `load workspace`
- **Description**: Load a workspace
- **Direct Parameter**: text - The name of the workspace
- **Returns**: boolean

#### `log message`
- **Description**: Log info for a record, file or action to the Window > Log panel
- **Direct Parameter**: text (optional) - The optional POSIX path or action
- **Parameters**:
  - `record` (record, optional): The record
  - `info` (text, optional): Additional information
- **Returns**: boolean

#### `lookup records with comment`
- **Description**: Lookup records with specified comment
- **Direct Parameter**: text - The comment
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: record list | missing value

#### `lookup records with content hash`
- **Description**: Lookup records with specified content hash
- **Direct Parameter**: text - The content hash
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: record list | missing value

#### `lookup records with file`
- **Description**: Lookup records whose last path component is the specified file
- **Direct Parameter**: text - The filename
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: content list | missing value

#### `lookup records with path`
- **Description**: Lookup records with specified path
- **Direct Parameter**: text - The path
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: record list | missing value

#### `lookup records with tags`
- **Description**: Lookup records with all or any of the specified tags
- **Direct Parameter**: text list - The tags
- **Parameters**:
  - `any` (boolean, optional): Lookup any or all tags
  - `in` (database, optional): The database
- **Returns**: record list | missing value

#### `lookup records with URL`
- **Description**: Lookup records with specified URL
- **Direct Parameter**: text - The URL or path
- **Parameters**:
  - `in` (database, optional): The database
- **Returns**: record list | missing value

#### `merge`
- **Description**: Merge a list of records as an RTF/PDF document
- **Parameters**:
  - `in` (parent, optional): The destination group
  - `records` (record list): The records to merge
- **Returns**: record | missing value

#### `move`
- **Description**: Move all instances of a record to a different group
- **Parameters**:
  - `record` (record | record list): The record(s) to move
  - `from` (parent, optional): The source group
  - `to` (parent): The destination group
- **Returns**: record | record list | missing value

#### `move into database`
- **Description**: Move an external/indexed record into the database
- **Parameters**:
  - `record` (record): The record to move
- **Returns**: boolean

#### `move to external folder`
- **Description**: Move an internal record to the enclosing external folder
- **Parameters**:
  - `record` (record): The record to move
  - `to` (text, optional): The POSIX path of the destination folder
- **Returns**: boolean

#### `open database`
- **Description**: Open an existing database
- **Direct Parameter**: text - POSIX file path of database
- **Returns**: database | missing value

#### `open tab for`
- **Description**: Open a new tab for the specified URL or record in a think window
- **Parameters**:
  - `record` (record, optional): The record to open
  - `URL` (text, optional): The URL to open
  - `referrer` (text, optional): The HTTP referrer
  - `in` (think window, optional): The think window
- **Returns**: tab | missing value

#### `open window for`
- **Description**: Open a main or document window for the specified record
- **Parameters**:
  - `record` (record): The record to open
  - `enforcement` (boolean, optional): Force open a new window
- **Returns**: think window | missing value

#### `optimize`
- **Description**: Backup & optimize a database
- **Parameters**:
  - `database` (database): The database to optimize
- **Returns**: boolean

#### `paste clipboard`
- **Description**: Create a new record with the contents of the clipboard
- **Parameters**:
  - `to` (parent, optional): The destination group
- **Returns**: record | missing value

#### `perform batch configuration`
- **Description**: Perform one of the batch processing configurations
- **Direct Parameter**: text - The name of the configuration
- **Parameters**:
  - `record` (record | record list): The record(s) to use
- **Returns**: boolean

#### `perform smart rule`
- **Description**: Perform one or all smart rules
- **Parameters**:
  - `name` (text, optional): The name of the smart rule
  - `record` (record, optional): The record
  - `trigger` (rule event, optional): The optional event to trigger
- **Returns**: boolean

#### `refresh`
- **Description**: Refresh a record
- **Parameters**:
  - `record` (record): The record to refresh
- **Returns**: boolean

#### `replicate`
- **Description**: Replicate a record
- **Parameters**:
  - `record` (record | record list): The record(s) to replicate
  - `to` (parent): The destination group
- **Returns**: record | record list | missing value

#### `restore record with`
- **Description**: Restore saved version of a record
- **Parameters**:
  - `version` (record): The saved version
- **Returns**: boolean

#### `save version of`
- **Description**: Save version of current record
- **Parameters**:
  - `record` (record): The record
- **Returns**: record | missing value

#### `save workspace`
- **Description**: Save a workspace
- **Direct Parameter**: text - The name of the workspace
- **Returns**: boolean

#### `search`
- **Description**: Search for records in specified group or all databases
- **Direct Parameter**: text (optional) - The search string
- **Parameters**:
  - `comparison` (search comparison, optional): The comparison to use
  - `exclude subgroups` (boolean, optional): Don't search in subgroups
  - `in` (parent, optional): The group to search in
- **Returns**: record list | missing value

#### `set cell at`
- **Description**: Set cell at specified position of a sheet
- **Direct Parameter**: specifier - The tab, window or record of a sheet.
- **Parameters**:
  - `column` (integer | text): The index or name of the column
  - `row` (integer): The row of the cell
  - `to` (text): The content of the cell
- **Returns**: boolean

#### `show progress indicator`
- **Description**: Show a progress indicator or update an already visible indicator
- **Direct Parameter**: text - The title of the progress
- **Parameters**:
  - `cancel button` (boolean, optional): Display a button to cancel
  - `steps` (number, optional): The number of steps
- **Returns**: boolean

#### `show search`
- **Description**: Perform search in frontmost main window
- **Direct Parameter**: text (optional) - The search string
- **Parameters**:
  - `comparison` (search comparison, optional): The comparison to use
  - `exclude subgroups` (boolean, optional): Don't search in subgroups
- **Returns**: boolean

#### `start downloads`
- **Description**: Start queue of download manager
- **Returns**: boolean

#### `step progress indicator`
- **Description**: Go to next step of a progress
- **Direct Parameter**: text (optional) - The info for the current step
- **Returns**: boolean

#### `stop downloads`
- **Description**: Stop queue of download manager
- **Returns**: boolean

#### `summarize annotations of`
- **Description**: Summarize highlights & annotations of records
- **Parameters**:
  - `in` (parent, optional): The destination group
  - `records` (content list): The records to summarize
  - `to` (summary type): The desired format
- **Returns**: content | missing value

#### `summarize contents of`
- **Description**: Summarize content of records
- **Parameters**:
  - `in` (parent, optional): The destination group
  - `records` (content list): The records to summarize
  - `to` (summary type): The desired format
  - `as` (summary style, optional): The desired summary style
- **Returns**: content | missing value

#### `summarize mentions of`
- **Description**: Summarize mentions of records
- **Parameters**:
  - `in` (parent, optional): The destination group
  - `records` (content list): The records to summarize
  - `to` (summary type): The desired format
- **Returns**: content | missing value

#### `summarize text`
- **Description**: Summarizes text
- **Direct Parameter**: text - The text to summarize
- **Parameters**:
  - `as` (summary style, optional): The desired summary style
- **Returns**: text | missing value

#### `synchronize`
- **Description**: Synchronizes records with the filesystem or databases with their sync locations
- **Parameters**:
  - `record` (record, optional): The external record to update
  - `database` (database, optional): The database to synchronize
- **Returns**: boolean

#### `transcribe`
- **Description**: Transcribes speech, text or notes of a record
- **Parameters**:
  - `record` (content): An audio/video/PDF/image record
  - `language` (text, optional): ISO language code
  - `timestamps` (boolean, optional): Include timestamps
- **Returns**: text | missing value

#### `update`
- **Description**: Update text of a plain/rich text, Markdown document, formatted note or HTML page
- **Parameters**:
  - `record` (record): The record to update
  - `with text` (text | rich text): The text to update/set/insert/append
  - `mode` (update mode): The desired mode
  - `URL` (text, optional): The URL of the text
- **Returns**: boolean

#### `update thumbnail`
- **Description**: Update existing thumbnail of a record
- **Parameters**:
  - `of` (record): The record
- **Returns**: boolean

#### `verify`
- **Description**: Verify a database
- **Parameters**:
  - `database` (database): The database to verify
- **Returns**: integer - Total number of errors

### Text Suite Commands

#### `bold`
- **Description**: Bold some text
- **Direct Parameter**: specifier - The text

#### `italicize`
- **Description**: Italicize some text
- **Direct Parameter**: specifier - The text

#### `plain`
- **Description**: Make some text plain
- **Direct Parameter**: specifier - The text

#### `reformat`
- **Description**: Reformat some text
- **Direct Parameter**: specifier - The text

#### `scroll to visible`
- **Description**: Scroll to and animate some text
- **Direct Parameter**: specifier - The text

#### `strike`
- **Description**: Strike some text
- **Direct Parameter**: specifier - The text

#### `unbold`
- **Description**: Unbold some text
- **Direct Parameter**: specifier - The text

#### `underline`
- **Description**: Underline some text
- **Direct Parameter**: specifier - The text

#### `unitalicize`
- **Description**: Unitalicize some text
- **Direct Parameter**: specifier - The text

#### `unstrike`
- **Description**: Unstrike some text
- **Direct Parameter**: specifier - The text

#### `ununderline`
- **Description**: Ununderline some text
- **Direct Parameter**: specifier - The text

### OCR Commands Suite

#### `ocr`
- **Description**: Imports a PDF document or image with OCR
- **Parameters**:
  - `file` (text): POSIX path or file URL of the image file
  - `attributes` (PDF properties, optional): The PDF properties
  - `rotate by` (integer, optional): Rotate the image 0, 90, 180 or 270 degrees
  - `to` (parent, optional): The destination group
  - `file type` (OCR convert type, optional): Specifies what type of file to convert to
  - `waiting for reply` (boolean, optional): Wait for reply or perform in background
- **Returns**: content | missing value

#### `convert image`
- **Description**: Converts a record to a new record and applies OCR
- **Parameters**:
  - `record` (content): A record containing an image
  - `to` (parent, optional): The destination group
  - `rotate by` (integer, optional): Rotate the image 0, 90, 180 or 270 degrees
  - `file type` (OCR convert type, optional): Specifies what type of file to convert to
  - `waiting for reply` (boolean, optional): Wait for reply or perform in background
- **Returns**: content | missing value

### Imprint Commands Suite

#### `imprinter configuration names`
- **Description**: Returns list of imprinter configuration names
- **Returns**: text list | missing value

#### `imprint configuration`
- **Description**: Imprint the record with a given imprinter configuration
- **Direct Parameter**: text - The name of the imprinter configuration
- **Parameters**:
  - `to` (content): The image or PDF record to imprint
  - `waiting for reply` (boolean, optional): Wait for reply or perform in background
- **Returns**: boolean

#### `imprint`
- **Description**: Imprint the record with a configuration defined in the parameters
- **Parameters**:
  - `record` (content): The image or PDF record to imprint
  - `background color` (RGB color, optional): Background color as RGB value
  - `border color` (RGB color, optional): Border color as RGB value
  - `border style` (border style type, optional): The type of border
  - `border width` (integer, optional): Width of the border
  - `font` (text): The name of the font
  - `foreground color` (RGB color, optional): Foreground color as RGB value
  - `occurence` (occurrence type, optional): On what pages should the imprint occur
  - `outlined` (boolean, optional): The text will be drawn as an outline
  - `position` (imprint position): Specifies where the imprint will be drawn
  - `rotation` (integer, optional): Rotation value in degrees
  - `size` (integer): Size of the font
  - `strike through` (boolean, optional): The text is striked through
  - `text` (text): The text to imprint
  - `underlined` (boolean, optional): The text is underlined
  - `x offset` (integer, optional): An x offset in pixels from the position
  - `y offset` (integer, optional): An y offset in pixels from the position
  - `waiting for reply` (boolean, optional): Wait for reply or perform in background
- **Returns**: boolean

## Classes

### Standard Suite Classes

#### `application`
- **Description**: The application's top-level scripting object
- **Properties**:
  - `name` (text, read-only): The name of the application
  - `frontmost` (boolean, read-only): Is this the active application?
  - `version` (text, read-only): The version number of the application
- **Elements**:
  - `window` (read-only): Application windows

#### `window`
- **Description**: A window
- **Properties**:
  - `name` (text, read-only): The title of the window
  - `id` (integer, read-only): The unique identifier of the window
  - `index` (integer): The index of the window, ordered front to back
  - `bounds` (rectangle): The bounding rectangle of the window
  - `closeable` (boolean, read-only): Does the window have a close button?
  - `miniaturizable` (boolean, read-only): Does the window have a minimize button?
  - `miniaturized` (boolean): Is the window minimized right now?
  - `resizable` (boolean, read-only): Can the window be resized?
  - `visible` (boolean): Is the window visible right now?
  - `zoomable` (boolean, read-only): Does the window have a zoom button?
  - `zoomed` (boolean): Is the window zoomed right now?

### Text Suite Classes

#### `rich text`
- **Description**: Rich (styled) text
- **Properties**:
  - `font` (text | missing value): The name of the font of the first character
  - `size` (number): The size in points of the first character
  - `color` (RGB color | missing value): The color of the first character
- **Elements**:
  - `attachment`: Text attachments
  - `attribute run`: Attribute runs
  - `character`: Characters
  - `paragraph`: Paragraphs
  - `word`: Words

#### `attachment`
- **Description**: Represents an inline text attachment
- **Inherits**: rich text
- **Properties**:
  - `file name` (file | missing value): The path to the file for the attachment

#### `attribute run`
- **Description**: Subdivides the text into chunks that all have the same attributes
- **Inherits**: rich text

#### `character`
- **Description**: Subdivides the text into characters
- **Inherits**: rich text

#### `paragraph`
- **Description**: Subdivides the text into paragraphs
- **Inherits**: rich text

#### `word`
- **Description**: Subdivides the text into words
- **Inherits**: rich text

### Extended Text Suite Classes

Extended properties for text classes:
- `baseline offset` (real): Number of points shifted above or below the normal baseline
- `background` (RGB color | missing value): The background color of the first character
- `first line head indent` (real): Paragraph first line head indent (always 0 or positive)
- `head indent` (real): Paragraph head indent (always 0 or positive)
- `underlined` (boolean): Is the first character underlined?
- `line spacing` (real): Line spacing of the text
- `multiple line height` (real): Multiple line height of the text
- `maximum line height` (real): Maximum line height of the text
- `minimum line height` (real): Minimum line height of the text
- `paragraph spacing` (real): Paragraph spacing of the text
- `superscript` (integer): The superscript level of the text
- `tail indent` (real): Paragraph tail indent
- `text content` (text | missing value): The actual text content
- `alignment` (text alignment): Alignment of the text
- `URL` (text | missing value): Link of the text

### DEVONthink Suite Classes

#### `application` (DEVONthink)
- **Description**: DEVONthink's top level scripting object
- **Inherits**: application (Standard Suite)
- **Properties**:
  - `bates number` (integer): Current bates number
  - `cancelled progress` (boolean, read-only): Specifies if a process should be cancelled
  - `current chat engine` (chat engine | missing value, read-only): The default chat engine
  - `current chat model` (text | missing value, read-only): The default chat model
  - `current group` (parent | missing value, read-only): The selected group of the frontmost window
  - `current workspace` (text | missing value, read-only): The name of the currently used workspace
  - `current database` (database | missing value, read-only): The currently used database
  - `content record` (content | missing value, read-only): The record of the visible document
  - `inbox` (database | missing value, read-only): The global inbox
  - `incoming group` (parent | missing value, read-only): The default group for new notes
  - `label names` (text list | missing value, read-only): List of all 7 label names
  - `last downloaded response` (HTTP response | missing value, read-only): The last downloaded HTTP(S) response
  - `last downloaded URL` (text | missing value, read-only): The actual URL of the last download
  - `preferred import destination` (parent | missing value, read-only): The default destination for data from external sources
  - `reading list` (reading list item list | missing value, read-only): The items of the reading list
  - `strict duplicate recognition` (boolean): Specifies if recognition of duplicates is strict
  - `workspaces` (text list | missing value, read-only): The names of all available workspaces
- **Elements**:
  - `database`: Open databases
  - `think window`: Think windows
  - `main window`: Main windows
  - `document window`: Document windows
  - `selected record`: Selected records

#### `record`
- **Description**: A database record
- **Properties**:
  - `id` (integer, read-only): The scripting identifier of a record
  - `MIME type` (text | missing value, read-only): The (proposed) MIME type
  - `uuid` (text | missing value, read-only): The unique and persistent identifier
  - `addition date` (date | missing value, read-only): Date when the record was added
  - `aliases` (text | missing value): Wiki aliases (separated by commas or semicolons)
  - `altitude` (real): The altitude in metres
  - `annotation` (content | missing value): Annotation of a record
  - `annotation count` (integer, read-only): The number of annotations
  - `attached script` (text | missing value): POSIX path of script attached to a record
  - `attachment count` (integer, read-only): The number of attachments
  - `attributes change date` (date | missing value): The change date of the record's attributes
  - `bates number` (integer): Bates number
  - `cells` (array list): The cells of a sheet
  - `character count` (integer, read-only): The character count
  - `color` (RGB color | missing value): The color of a record
  - `columns` (text list | missing value, read-only): The column names of a sheet
  - `comment` (text | missing value): The comment
  - `content hash` (text | missing value, read-only): Stored SHA1 hash
  - `creation date` (date | missing value): The creation date
  - `custom meta data` (dictionary | missing value): User-defined metadata
  - `data` (raw data | missing value): The file data
  - `database` (database | missing value, read-only): The database of the record
  - `date` (date | missing value): The (creation/modification) date
  - `digital object identifier` (text | missing value, read-only): DOI extracted from text
  - `dimensions` (integer list, read-only): The width and height in pixels or points
  - `document amount` (text | missing value, read-only): Amount extracted from text
  - `document date` (date | missing value, read-only): First date extracted from text
  - `all document dates` (date list | missing value, read-only): All dates extracted from text
  - `document name` (text | missing value, read-only): Name based on text or properties
  - `dpi` (number, read-only): The resolution of an image in dpi
  - `duplicates` (record list | missing value, read-only): The duplicates of a record
  - `duration` (real, read-only): The duration of audio and video files
  - `encrypted` (boolean, read-only): Specifies if a document is encrypted
  - `exclude from chat` (boolean): Exclude group or record from chat
  - `exclude from classification` (boolean): Exclude group or record from classifying
  - `exclude from search` (boolean): Exclude group or record from searching
  - `exclude from see also` (boolean): Exclude record from see also
  - `exclude from tagging` (boolean): Exclude group from tagging
  - `exclude from Wiki linking` (boolean): Exclude record from automatic Wiki linking
  - `filename` (text | missing value, read-only): The current filename
  - `flag` (boolean): The flag of a record
  - `geolocation` (text | missing value): The human readable geographical location
  - `height` (number, read-only): The height in pixels or points
  - `image` (any | missing value): The image or PDF document
  - `indexed` (boolean, read-only): Indexed or imported record
  - `international standard book number` (text | missing value, read-only): ISBN extracted from text
  - `interval` (real): Refresh interval of a feed
  - `kind` (text | missing value, read-only): The human readable and localized kind
  - `label` (integer): Index of label (0-7)
  - `language` (text | missing value, read-only): ISO code of language of document
  - `latitude` (real): The latitude in degrees
  - `location` (text | missing value, read-only): The primary location as a POSIX path
  - `location group` (parent | missing value, read-only): The group of the primary location
  - `location with name` (text | missing value, read-only): The full primary location including name
  - `locking` (boolean): The locking of a record
  - `longitude` (real): The longitude in degrees
  - `markdown source` (text | missing value, read-only): The Markdown source
  - `meta data` (dictionary | missing value, read-only): Document metadata containing the following optional keys:
		- `kMDItemTitle` (text) : Title
		- `kMDItemHeadline` (text) : Headline
		- `kMDItemSubject` (text) : Subject
		- `kMDItemDescription` (text) : Description
		- `kMDItemCopyright` (text) : Copyright
		- `kMDItemComment` (text) : Comment
		- `kMDItemURL` (text) : URL
		- `kMDItemCreator` (text) : Creator
		- `kMDItemProducer` (text) : Producer
		- `kMDItemComposer` (text) : Composer
		- `kMDItemAlbum` (text) : Album
		- `kMDItemKeywords` (comma-separated text) : Keywords
		- `kMDItemOrganizations` (comma-separated text) : Organizations
		- `kMDItemContributors` (comma-separated text) : Contributors
		- `kMDItemEditors` (comma-separated text) : Editors
		- `kMDItemPublishers` (comma-separated text) : Publishers
		- `kMDItemAuthors` (comma-separated text) : Authors
		- `kMDItemAuthorEmailAddresses` (comma-separated text) : Email addresses of authors
		- `kMDItemRecipients` (comma-separated text) : Recipients
		- `kMDItemRecipientEmailAddresses` (comma-separated text) : Email addresses of recipients
		- `kMDItemEmailAddresses` (comma-separated text) : Generic email addresses
  - `modification date` (date | missing value): The modification date
  - `name` (text): The name
  - `name without date` (text | missing value, read-only): The name without any dates
  - `name without extension` (text | missing value, read-only): The name without a file extension
  - `newest document date` (date | missing value, read-only): Newest date extracted from text
  - `number of duplicates` (integer, read-only): The number of duplicates
  - `number of hits` (integer): The number of hits
  - `number of replicants` (integer, read-only): The number of replicants
  - `oldest document date` (date | missing value, read-only): Oldest date extracted from text
  - `original name` (text, read-only): The original name
  - `opening date` (date | missing value, read-only): Date when opened last time
  - `page count` (integer, read-only): The page count (PDF documents)
  - `paginated PDF` (raw data | missing value, read-only): A printed/converted PDF
  - `path` (text | missing value): The POSIX file path
  - `pending` (boolean, read-only): Flag whether contents haven't been downloaded yet
  - `plain text` (text | missing value): The plain text. Setting this property of images, PDF documents, audio or video files sets the searchable, e.g. transcribed, text
  - `proposed filename` (text | missing value, read-only): The proposed filename
  - `rating` (integer): Rating (0-5)
  - `record type` (data type, read-only): The type of a record
  - `reference URL` (text | missing value, read-only): The URL to reference/link back to a record
  - `reminder` (reminder | missing value): Reminder of a record
  - `rich text` (rich text | missing value): The rich text
  - `score` (real, read-only): The score of the last comparison, classification or search
  - `size` (integer, read-only): The size in bytes
  - `source` (text | missing value): The HTML/XML source
  - `tag type` (tag type, read-only): The tag type
  - `tags` (array | missing value): The tags
  - `thumbnail` (any | missing value): The thumbnail
  - `unread` (boolean): The unread flag
  - `URL` (text | missing value): The URL
  - `web archive` (raw data | missing value, read-only): The web archive if available
  - `width` (number, read-only): The width in pixels or points
  - `word count` (integer, read-only): The word count
- **Elements**:
  - `child`: Child records
  - `incoming reference`: Incoming references
  - `incoming Wiki reference`: Incoming Wiki references
  - `outgoing reference`: Outgoing references
  - `outgoing Wiki reference`: Outgoing Wiki references
  - `parent`: Parent groups

#### `database`
- **Description**: A database
- **Properties**:
  - `id` (integer, read-only): The scripting identifier
  - `uuid` (text | missing value, read-only): The unique and persistent identifier
  - `annotations group` (parent | missing value, read-only): The group for annotations
  - `comment` (text | missing value): The comment of the database
  - `current group` (parent | missing value, read-only): The selected group of the frontmost window
  - `incoming group` (parent | missing value, read-only): The default group for new notes
  - `encrypted` (boolean, read-only): Specifies if a database is encrypted
  - `revision proof` (boolean, read-only): Specifies if a database is revision-proof
  - `read only` (boolean, read-only): Specifies if a database is read-only
  - `Spotlight indexing` (boolean): Specifies if Spotlight indexing is enabled
  - `versioning` (boolean): Specifies whether versioning of documents is enabled
  - `name` (text): The name of the database
  - `filename` (text | missing value, read-only): The filename
  - `path` (text | missing value, read-only): The POSIX path
  - `root` (parent | missing value, read-only): The top level group
  - `tags group` (parent | missing value, read-only): The group for tags
  - `trash group` (parent | missing value, read-only): The trash's group
  - `versions group` (parent | missing value, read-only): The group for versioning
- **Elements**:
  - `content`: Content records
  - `parent`: Parent groups
  - `smart parent`: Smart groups
  - `tag group`: Tags

#### `think window`
- **Description**: A document window or main window
- **Inherits**: window
- **Properties**:
  - `PDF` (raw data | missing value, read-only): A PDF without pagination
  - `web archive` (raw data | missing value, read-only): Web archive of the current web page
  - `current line` (integer, read-only): Zero-based index of current line
  - `current movie frame` (raw data | missing value, read-only): Image of current movie frame
  - `current time` (real): Time of current audio/video file
  - `current page` (integer): Zero-based index of current PDF page
  - `current tab` (tab | missing value): The selected tab
  - `database` (database | missing value, read-only): The database of the window
  - `content record` (content | missing value, read-only): The record of the visible document
  - `loading` (boolean, read-only): Specifies if the current web page is still loading
  - `number of columns` (integer, read-only): Number of columns of the current sheet
  - `number of rows` (integer, read-only): Number of rows of the current sheet
  - `paginated PDF` (raw data | missing value, read-only): A printed PDF with pagination
  - `reference URL` (text | missing value, read-only): The URL to reference/link back
  - `selected column` (integer): Index of selected column of the current sheet
  - `selected columns` (integer list, read-only): Indices of selected columns
  - `selected row` (integer): Index of selected row of the current sheet
  - `selected rows` (integer list, read-only): Indices of selected rows
  - `source` (text | missing value, read-only): The HTML source of the current web page
  - `URL` (text | missing value): The URL of the current web page
  - `selected text` (text | rich text | missing value): The rich text for the selection. Returns an empty string in case of no selection or missing value in case of no tab/document
  - `plain text` (text | missing value, read-only): The plain text
  - `rich text` (text | rich text | missing value): The rich text
- **Elements**:
  - `tab`: Tabs

#### `main window`
- **Description**: A main window
- **Inherits**: think window
- **Properties**:
  - `search results` (record list | missing value): The search results
  - `root` (parent | smart parent | missing value): The top level group of the window
  - `search query` (text | missing value): The search query
- **Elements**:
  - `selected record`: Selected records

#### `document window`
- **Description**: A document window
- **Inherits**: think window
- **Properties**:
  - `content record` (content | missing value): The record of the visible document

#### `tab`
- **Description**: A tab of a think window
- **Properties**:
  - `id` (integer, read-only): The unique identifier of the tab
  - `PDF` (raw data | missing value, read-only): A PDF without pagination
  - `web archive` (raw data | missing value, read-only): Web archive of the current web page
  - `current line` (integer, read-only): Zero-based index of current line
  - `current movie frame` (raw data | missing value, read-only): Image of current movie frame
  - `current time` (real): Time of current audio/video file
  - `current page` (integer): Zero-based index of current PDF page
  - `database` (database | missing value, read-only): The database of the tab
  - `content record` (content | missing value, read-only): The record of the visible document
  - `loading` (boolean, read-only): Specifies if the current web page is still loading
  - `number of columns` (integer, read-only): Number of columns of the current sheet
  - `number of rows` (integer, read-only): Number of rows of the current sheet
  - `paginated PDF` (raw data | missing value, read-only): A printed PDF with pagination
  - `reference URL` (text | missing value, read-only): The URL to reference/link back
  - `selected column` (integer): Index of selected column of the current sheet
  - `selected columns` (integer list, read-only): Indices of selected columns
  - `selected row` (integer): Index of selected row of the current sheet
  - `selected rows` (integer list, read-only): Indices of selected rows
  - `source` (text | missing value, read-only): The HTML source of the current web page
  - `think window` (think window | missing value, read-only): The think window of the tab
  - `URL` (text | missing value): The URL of the current web page
  - `selected text` (text | rich text | missing value): The rich text for the selection. Returns an empty string in case of no selection
  - `plain text` (text | missing value, read-only): The plain text
  - `rich text` (text | rich text | missing value): The rich text

#### `parent`
- **Description**: A parent (either group, feed or tag) of a record
- **Inherits**: record

#### `content`
- **Description**: A content record of a database
- **Inherits**: record

#### `child`
- **Description**: A child record of a group
- **Inherits**: record

#### `selected record`
- **Description**: A selected record
- **Inherits**: record

#### `smart parent`
- **Description**: A smart group
- **Inherits**: record
- **Properties**:
  - `exclude subgroups` (boolean): Exclude subgroups from searching
  - `highlight occurrences` (boolean): Highlight found occurrences in documents
  - `search group` (parent | missing value): Group to search in
  - `search predicates` (text | missing value): String representation of the conditions

#### `tag group`
- **Description**: A tag of a database
- **Inherits**: parent

#### `incoming reference`
- **Description**: A reference from another record
- **Inherits**: record

#### `incoming Wiki reference`
- **Description**: An automatic Wiki reference from another record
- **Inherits**: record

#### `outgoing reference`
- **Description**: A reference to another record
- **Inherits**: record

#### `outgoing Wiki reference`
- **Description**: An automatic Wiki reference to another record
- **Inherits**: record

#### `reminder`
- **Description**: A reminder of a record
- **Properties**:
  - `alarm` (reminder alarm): Alarm of reminder
  - `alarm string` (text | missing value): Name of sound, text to speak, etc.
  - `day of week` (reminder day): Scheduled day of week
  - `due date` (date | missing value): Due date
  - `interval` (integer): Interval of schedule
  - `masc` (integer): Bitmap specifying scheduled days/months
  - `schedule` (reminder schedule): Schedule of reminder
  - `week of month` (reminder week): Scheduled week of month

## Enumerations

### Standard Suite

#### `save options`
- `yes`: Save the file
- `no`: Do not save the file
- `ask`: Ask the user whether or not to save the file

#### `printing error handling`
- `standard`: Standard PostScript error handling
- `detailed`: Print a detailed report of PostScript errors

### Text Suite

#### `text alignment`
- `left`: Left alignment
- `center`: Center alignment
- `right`: Right alignment
- `justified`: Justified alignment
- `natural`: Natural alignment

### DEVONthink Suite

#### `comparison type`
- `data comparison`: Uses text & metadata
- `tags comparison`: Uses tags

#### `convert type`
- `bookmark`: Bookmark
- `simple`: Plain text
- `rich`: Rich text
- `note`: Formatted Note
- `markdown`: Markdown document
- `HTML`: HTML document
- `webarchive`: Web Archive
- `PDF document`: PDF document (Paginated)
- `single page PDF document`: PDF document (One Page)
- `PDF without annotations`: PDF document without annotations
- `PDF with annotations burnt in`: PDF/A document with annotations burnt in

#### `data type`
- `group`: Group
- `smart group`: Smart group
- `feed`: RSS, RDF or Atom feed
- `bookmark`: Internet or filesystem location
- `formatted note`: Formatted Note
- `HTML`: HTML document
- `webarchive`: Web Archive
- `markdown`: Markdown document
- `txt`: Text document
- `RTF`: RTF document
- `RTFD`: RTFD document
- `picture`: Picture
- `multimedia`: Audio or video file
- `PDF document`: PDF document
- `sheet`: Sheet
- `XML`: XML document
- `property list`: Property list
- `AppleScript file`: AppleScript file
- `email`: Email
- `unknown`: Unknown file

#### `reminder alarm`
- `no alarm`: No alarm
- `dock`: Bounce Dock icon
- `sound`: Play sound
- `speak`: Speak text
- `notification`: Display notification
- `alert`: Display alert
- `open internally`: Open in DEVONthink
- `open externally`: Open in default application
- `launch`: Launch URL
- `mail with item link`: Send mail with item link
- `mail with attachment`: Send mail with attachment
- `add to reading list`: Add to reading list
- `embedded script`: Execute embedded script (AppleScript)
- `embedded JXA script`: Execute embedded script (JavaScript)
- `external script`: Execute external script

#### `reminder day`
- `no day`: No day
- `sunday`: Sunday
- `monday`: Monday
- `tuesday`: Tuesday
- `wednesday`: Wednesday
- `thursday`: Thursday
- `friday`: Friday
- `saturday`: Saturday
- `any day`: Any day
- `workdays`: Workdays
- `weekend`: Weekend

#### `reminder schedule`
- `never`: No schedule
- `once`: One shot schedule
- `hourly`: Hourly schedule
- `daily`: Daily schedule
- `weekly`: Weekly schedule
- `monthly`: Monthly schedule
- `yearly`: Yearly schedule

#### `reminder week`
- `no week`: No week
- `last week`: Last week of month
- `first week`: First week of month
- `second week`: Second week of month
- `third week`: Third week of month
- `fourth week`: Fourth week of month

#### `rule event`
- `no event`: No event
- `open event`: Event after opening items
- `open externally event`: Event after opening items externally
- `edit externally event`: Event after editing items externally
- `launch event`: Event after launching the URL of items
- `creation event`: Event after creating items
- `import event`: Event after importing items
- `clipping event`: Event after clipping websites
- `download event`: Event after downloading items
- `rename event`: Event after renaming items
- `move event`: Event after moving items
- `classify event`: Event after classifying items
- `replicate event`: Event after replicating items
- `duplicate event`: Event after duplicating items
- `tagging event`: Event after tagging items
- `flagging event`: Event after flagging items
- `labelling event`: Event after labelling items
- `rating event`: Event after rating items
- `move into database event`: Event after consolidating items
- `move to external folder event`: Event after deconsolidating items
- `commenting event`: Event after commenting items
- `convert event`: Event after converting items
- `OCR event`: Event after performing OCR
- `imprint event`: Event after imprinting items
- `trashing event`: Event before trashing items

#### `search comparison`
- `no case`: Case insensitive search
- `no umlauts`: Diacritics insensitive search
- `fuzzy`: Fuzzy search
- `related`: Related search

#### `summary style`
- `list summary`: Bullet list summary
- `key points summary`: Key points summary
- `table summary`: Table summary
- `text summary`: Text summary
- `custom summary`: Custom summary

#### `summary type`
- `markdown`: Markdown document
- `simple`: Plain text
- `rich`: Rich text
- `sheet`: Sheet

#### `tag type`
- `no tag`: No tag (not a group or excluded from tagging)
- `ordinary tag`: An 'ordinary' tag located inside of the tags group
- `group tag`: A 'group' tag located outside of the tags group

#### `update mode`
- `replacing`: Replace text
- `appending`: Append text
- `inserting`: Insert text

#### `concordance sorting`
- `weight`: Sorted by weight
- `frequency`: Sorted by frequency

#### `chat engine`
- `ChatGPT`: OpenAI's ChatGPT
- `Claude`: Anthropic's Claude
- `Gemini`: Google's Gemini
- `Mistral`: Mistral's AI
- `OpenRouter`: OpenRouter AI
- `Perplexity`: Perplexity's AI
- `OpenAI Compatible`: OpenAI-compatible engine
- `LM Studio`: Element Lab's LM Studio
- `Ollama`: Local Ollama installation
- `Remote Ollama`: Remote Ollama server

#### `chat usage`
- `cheapest`: Least tokens, low reasoning &a search effort and reduced vision quality
- `auto`: Automatic
- `best`: Unlimited tokens, high reasoning & search effort and highest vision quality

#### `image engine`
- `GPTImage1Mini`: OpenAI's GPT-Image-1-Mini
- `GPTImage1`: OpenAI's GPT-Image-1.5
- `FluxSchnell`: Black Forest Labs' Flux Schnell
- `FluxPro`: Black Forest Labs' Flux Pro
- `FluxProUltra`: Black Forest Labs' Flux Pro Ultra
- `Recraft3`: Recraft AI's Recraft 3
- `StableDiffusion`: Stability AI's Stable Diffusion 3.5 Large
- `StableDiffusionTurbo`: Stability AI's Stable Diffusion 3.5 Large Turbo
- `Imagen4`: Google's Imagen 4
- `Imagen4Fast`: Google's Imagen 4 Fast
- `Imagen4Ultra`: Google's Imagen 4 Ultra
- `NanoBanana`: Google's Nano Banana

### OCR Commands Suite

#### `OCR convert type`
- `Annotate document`: Annotation
- `Comment document`: Comment
- `PDF document`: PDF document
- `RTF`: RTF document
- `Word document`: Microsoft Word document
- `webarchive`: Web Archive

### Imprint Commands Suite

#### `border style type`
- `none`: No border, this is the default
- `rectangle`: Rectangular border
- `rounded rectangle`: Rectangle with rounded corners
- `oval`: Oval border
- `left arrow`: Left arrow
- `right arrow`: Right arrow

#### `imprint position`
- `top left`: Position imprint top left of page
- `top center`: Position imprint top center of page
- `top right`: Position imprint top right of page
- `center left`: Position imprint center left of page
- `centered`: Position imprint in the center of the page
- `center right`: Position imprint center right of page
- `bottom left`: Position imprint bottom left of page
- `bottom center`: Position imprint bottom center of page
- `bottom right`: Position imprint bottom right of page

#### `occurrence type`
- `every page`: Imprint every page, this is the default
- `first page only`: Imprint the first page only
- `even pages`: Imprint even pages only
- `odd pages`: Imprint odd pages only

## Record Types

### DEVONthink Suite

#### `authentication result`
- **Properties**:
  - `user` (text): The user
  - `password` (text): The password

#### `authentication result`
- **Properties**:
  - `user` (text): The user
  - `password` (text): The password

#### `chat model capabilities`
- **Properties**:
  - `context window` (integer): Context window size
  - `deep search` (boolean): Deep search support
  - `thinking` (boolean): Thinking ("reasoning") support
  - `tool calls` (boolean): Tool call support
  - `vision` (boolean): Vision support

#### `feed item`
- **Properties**:
  - `title` (text): The item's title
  - `description` (text): The item's description
  - `author` (text): The item's author
  - `URL` (text): The item's URL
  - `text content` (text): The item's content
  - `source` (text): The item's HTML source
  - `guid` (text): The item's unique identifier
  - `last modified` (text): The item's modification date
  - `tags` (array): The item's tags
  - `enclosures` (array): The item's enclosures

#### `group selector result`
- **Properties**:
  - `name` (text): The name
  - `selected group` (parent): The selected destination group
  - `tags` (text list): The tags

#### `HTTP response`
- **Properties**:
  - `HTTP status` (integer): The HTTP(s) status code
  - `last modified` (date): The last modification date
  - `content type` (text): The content type
  - `content length` (integer): The expected content length
  - `charset` (text): The charset
  - `error code` (integer): The error code, e.g. in case of a network failure.
  - `error domain` (text): The error domain, e.g. NSURLErrorDomain

#### `reading list item`
- **Properties**:
  - `URL` (text): The item's url
  - `title` (text): The item's title
  - `unread` (boolean): The item's unread flag
  - `date` (date): The item's date

### OCR Commands Suite

#### `PDF properties`
- **Properties**:
  - `author` (text): The document's author
  - `title` (text): The document's title
  - `subject` (text): The document's subject
  - `keywords` (text): The document's keywords

## Value Types

### Standard Suite

#### `dictionary`
- **Description**: Dictionary containing key-value pairs

#### `raw data`
- **Description**: Raw data

#### `RGB color`
- **Description**: An RGB color

#### `array`
- **Description**: Array of items

## Print Settings Record

#### `print settings`
- **Properties**:
  - `copies` (integer): The number of copies to be printed
  - `collating` (boolean): Should printed copies be collated?
  - `starting page` (integer): The first page to be printed
  - `ending page` (integer): The last page to be printed
  - `pages across` (integer): Number of logical pages laid across a physical page
  - `pages down` (integer): Number of logical pages laid out down a physical page
  - `requested print time` (date): The time at which the desktop printer should print
  - `error handling` (printing error handling): How errors are handled
  - `fax number` (text): For fax number
  - `target printer` (text): For target printer
